<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\WidgetAreas
 * @author  StudioPress
 * @license GPL-2.0+
 * @link    http://my.studiopress.com/themes/genesis/
 */

add_action( 'admin_bar_menu', 'genesis_cpt_archive_settings_link', 999 );
/**
 * Adds a toolbar link to edit the custom post archive settings
 *
 * @since 2.3.0
 *
 * @global WP_Admin_Bar $wp_admin_bar
 *
 * @param WP_Admin_Bar $wp_admin_bar WP_Admin_Bar instance.
 * @return WP_Admin_Bar Return `$wp_admin_bar` early if in admin, not a CPT archive, not a valid post type,
 *                      or a post type that does not have support for `genesis-cpt-archive-settings`.
 */
function genesis_cpt_archive_settings_link( $wp_admin_bar ) {

	// Bail if in admin, not a CPT archive, or post_type doesn't have support for genesis-cpt-archive-settings.
	if ( is_admin() || ! is_post_type_archive() || ! genesis_has_post_type_archive_support() ) {
		return $wp_admin_bar;
	}
	// Get the post type we're viewing.
	$post_type = get_post_type();
	// Bail if we didn't get a valid post type.
	if ( ! $post_type ) {
		return $wp_admin_bar;
	}
	// Add our toolbar link.
	$args = array(
		'id'    => 'cpt-archive-settings',
		'title' => __('Edit Archive Settings', 'genesis'),
		'href'  => admin_url("edit.php?post_type={$post_type}&page=genesis-cpt-archive-{$post_type}"),
		'meta'  => array( 'class' => '' ),
	);
	$wp_admin_bar->add_node( $args );

}

add_action( 'wp_head', 'genesis_cpt_archive_settings_toolbar_styles' );
/**
 * Adds the pencil icon to the CPT archive settings menu link.
 *
 * Add custom CSS to `<head>`.
 *
 * @since  2.3.0
 */
function genesis_cpt_archive_settings_toolbar_styles() {
	// Bail if in admin, user is not logged in, admin bar is not showing, not a post type archive page,
	// or post type does not support genesis-cpt-archive-settings.
	if ( is_admin() || ! is_user_logged_in() || ! is_admin_bar_showing() || ! is_post_type_archive() || ! genesis_has_post_type_archive_support() ) {
		return;
	}
	echo '<style type="text/css">
	    #wpadminbar #wp-admin-bar-cpt-archive-settings > .ab-item:before {
		    content: "\f464";
		    top: 2px;
	    }
    </style>';
}
